/*------------------------------------------------------------------------------*
 * File Name:wkbookinfoTree.h		 											*
 * Creation: 																	*
 * Purpose: OriginC Header file													*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 08/25/09 QA81-14200 INDICATE_VARIABLE_TYPE							* 
 *	Hong 02/03/10 QA80-15050-P2_2 WKB_ORGANIZER_SHEET_LEVEL_ADD_FILE_INFO_FOR_IMPORT
 *------------------------------------------------------------------------------*/

#ifndef _WKBOOK_INFO_TREE_H_
#define _WKBOOK_INFO_TREE_H_

#define LIST_TREE_LEVEL			3
#define SHEET_INDEX_GEGIN_ID	1

#define BRN_WKS_COLUMNS			(BRN_LAST_ENTRY + 1)	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
#define BRN_WKS_ROWS			(BRN_LAST_ENTRY + 2)	///Jasmine 10/23/06 ADD_ROW_NUM

enum {	TYPE_WORKBOOK=1,		//Level 1
		
		TYPE_DATA_SHEETS, 	//Level 2
		TYPE_RESULT_SHEETS, 
		TYPE_ANALYSIS,
		TYPE_GRAPHS,
		TYPE_INI_STORAGES,			///Jasmine 01/22/07 SHOW_PAGE_INFO_ASCII_STORAGE	///change a better name, TYPE_PAGE_INFO
		TYPE_IMPORT_FILES,
		TYPE_BINARY_STORAGES,	///Jasmine 10/23/06 ADD_BINARY_STORAGES
		
		TYPE_SHEET,			//Level 3
		TYPE_FILE,
		TYPE_SECTION,
		TYPE_BRANCH,
		
		//TYPE_COLUMN,		///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
		TYPE_FILE_ITEM		//Level 4
};

#define STR_RELATED_ATTRIB 		"RelatedItem"

///Jasmine 08/25/09 QA81-14200 INDICATE_VARIABLE_TYPE
static void _justify_leaf_node_by_type(TreeNode& trNode)
{
	if( !trNode.FirstNode && is_numeric(trNode.strVal) )
		trNode.SetAttribute(STR_ATTRIB_DISPFMT, DISPLAY_EDITOR_ES_RIGHT);

	else
	{
		foreach(TreeNode trChild in trNode.Children)
		{
			_justify_leaf_node_by_type(trChild);
		}
	}
}
///End INDICATE_VARIABLE_TYPE

///Jasmine 01/31/07 QA70-9287 EDIT_STORAGE
static void _make_tree_node_expand(TreeNode& trNode)
{
	if(trNode.GetNodeCount() > 0)
		trNode.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	foreach(TreeNode trn in trNode.Children)
	{
		if(trn.GetNodeCount() > 0)
			_make_tree_node_expand(trn);
	}
}
///End EDIT_STORAGE
/// Hong 10/31/06 INFO_NODE_SHOULD_NOT_EDITABLE
//for temp, should remove when support Read-only branch TreeNode
static void _make_tree_node_readonly(TreeNode& trNode)
{
	//trNode.Enable = ENABLE_READ_ONLY;					//// AW 05/07/07 MORE_ON_MULTI_LINE_TEXT_DISPLAY
	foreach(TreeNode trn in trNode.Children)
	{
		if(trn.GetNodeCount() > 0)
			_make_tree_node_readonly(trn);
		else
		{
			if ( ENABLE_READONLY_SCROLL != trn.Enable )  //// AW 05/07/07 MORE_ON_MULTI_LINE_TEXT_DISPLAY
				trn.Enable = ENABLE_READ_ONLY;
		}
	}
}
/// end INFO_NODE_SHOULD_NOT_EDITABLE
/// Hong 12/02/06 NO_NEED_CHANGE_HERE
/*
/// Hong 11/13/06 MAKE_JULIAN_DATE_MORE_READABLE
static void _show_julian_date_by_string_mode(TreeNode& trNode)
{
	if(!trNode.IsValid())
		return ;
	double dJulian = trNode.dVal;
	string strVal = get_date_str(dJulian);
	trNode.strVal = strVal;
}
/// end MAKE_JULIAN_DATE_MORE_READABLE
*/
/// end NO_NEED_CHANGE_HERE
class WksInfoTree : public GridTreeControl
{
public:
	void InitPage(Page &wp)
	{
		m_wp=wp;
	}
	TreeNode UpdateDetail()
	{
		m_wbkInfo.Reset();
		getWksDetail(m_wp, m_wbkInfo);
		return m_wbkInfo;
	}
	bool ListContent(TreeNode &trGetN, TreeNode &tr)
	{
		if(!trGetN.IsValid() || !tr.IsValid())
			return false;
		string strName;
		TreeNode trList=tree_check_get_node(trGetN, tr.tagName, TRGP_BRANCH, STR_ATTRIB_BRANCH, (string)GETNBRANCH_OPEN);
		tree_node_copy_attribute(tr, trList, STR_LABEL_ATTRIB); /// Hong 11/07/07 v.8.0742 FIX_ERROR_LOCALIZED
		foreach(TreeNode trNode in tr.Children)
		{
			if(!trNode.GetAttribute(STR_LABEL_ATTRIB, strName))
				strName = trNode.tagName;
			TreeNode tn=trList.AddNode("Name");
			tn.SetAttribute(STR_LABEL_ATTRIB, _L("Name"));	//------ Folger 11/17/07 LOCALIZE_WORKBOOK_ORGANIZER
			tn.strVal=strName;
		}
			
		return true;
	}
	///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
	/*
	void GetStorage(TreeNode &trGetN, TreeNode &tr, int nType)
	{
		GETN_USE(trGetN)
		if(TYPE_INI_STORAGES == nType)
		{
			GETN_BEGIN_BRANCH(INIStorage, "page.info(Right-click to edit)")	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				getINIStorage(m_wp, GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(INIStorage)
			trGetN.INIStorage.SetAttribute(STR_TYPE_ATTRIB, nType);
		}
		if(TYPE_BINARY_STORAGES == nType)
		{
			GETN_BEGIN_BRANCH(UserTree, "User Tree(Right-click to edit)")	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				getBinaryStorageInfo(m_wp, GETN_CURRENT_SUBNODE);
			GETN_END_BRANCH(UserTree)			
			trGetN.UserTree.SetAttribute(STR_TYPE_ATTRIB, nType);
		}
	}*/
	///End EDIT_STORAGE
	///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW
	void GetSection(TreeNode &trGetN, LPCSTR lpcszTagName)
	{
		Tree trStorage;
		if(tree_add_info(trStorage, m_wp, NULL, NULL, NPLOT_FOR_WKS) && !trStorage.IsEmpty())
		{
			TreeNode tr = tree_get_node_by_tagname(trStorage, lpcszTagName, true);
			string strStorage = lpcszTagName;
			strStorage = strStorage.GetToken(0, '.');
			if(tr.Enable == 0 || tr.Enable == 2 || !strStorage.CompareNoCase("system"))
				_make_tree_node_readonly(tr);
			///Jasmine 08/26/09 QA81-14200 comment to wait a better design
			/////Jasmine 08/25/09 QA81-14200 INDICATE_VARIABLE_TYPE
			//if(lstrcmpi(lpcszTagName, "User.Variables") == 0)
				//_justify_leaf_node_by_type(tr);
			/////End INDICATE_VARIABLE_TYPE
			trGetN.Replace(tr, true, true, true);
			///Folger 04/24/07 ADD_NO_INFO_MSG
			if (trGetN.GetNodeCount() == 0)
			{
				TreeNode trNoInfo = trGetN.AddTextNode(_L("No Info (Right-Click to Edit)"), "NoInfo");
				trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
				trNoInfo.Enable = 2;
			}
			///End ADD_NO_INFO_MSG
		}
	}
	void GetBranch(TreeNode &trGetN, LPCSTR lpcszTagName)
	{
		Tree trStorage;
		if(tree_get_binary_storage(trStorage, m_wp, "TREE")  && !trStorage.IsEmpty())
		{
			TreeNode tr  = tree_get_node_by_tagname(trStorage, lpcszTagName, true);
			if(tr.Enable == 0 || tr.Enable == 2)
				_make_tree_node_readonly(tr);
			trGetN.Replace(tr, true, true, true);
			///Folger 04/24/07 ADD_NO_INFO_MSG
			if (trGetN.GetNodeCount() == 0)
			{
				TreeNode trNoInfo = trGetN.AddTextNode(_L("No Info (Right-Click to Edit)"), "NoInfo");
				trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
				trNoInfo.Enable = 2;
			}
			///End ADD_NO_INFO_MSG
		}
	}
	void GetFileInfo(TreeNode &trGetN, LPCSTR lpcszTagName)
	{
		Tree trInfo;
		if(tree_get_binary_storage(trInfo, m_wp, IFI_BINARY_STORAGE_NAME) && !trInfo.IsEmpty())
		{
			TreeNode tr = tree_get_node_by_tagname(trInfo, lpcszTagName, true);	
			_make_tree_node_readonly(tr);
			///Jasmine 08/26/09 QA81-14200 comment to wait a better design
			/////Jasmine 08/25/09 QA81-14200 INDICATE_VARIABLE_TYPE
			//if(tr.Variables)
				//_justify_leaf_node_by_type(tr.Variables);
			/////End INDICATE_VARIABLE_TYPE
			trGetN.Replace(tr, true, true, true);
		}
	}
	///End MAKE_A_CLEAR_TREE_VIEW
	bool GetPageInfo(TreeNode &trGetN, TreeNode &trPage)
	{
		//string strPageName;
		//trPage.GetAttribute(STR_LABEL_ATTRIB, strPageName);
		//Page pg(strPageName);
		//if(!pg)
			//return false;
		
		GETN_USE(trGetN)
		GETN_STR(SName, _L("Short Name"), m_wp.GetName())
		GETN_STR(LName, _L("Long Name"), m_wp.GetLongName())
		GETN_MULTILINE_TEXT(Comment, _L("Comment"), m_wp.GetComments())
		GETN_BEGIN_BRANCH(WindowTitle, _L("Window Title")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			//GETN_CHECK(LName, "Long Name", 0)
			//GETN_CHECK(SName, "Short Name", 0)
			//GETN_CHECK(Both, "Both", 0)
			///Folger 05/30/07 MODIFICATION_TITLE_SHOW_DEFAULT_VALUE
			if (m_wp.TitleShow == 0)
				m_wp.TitleShow = 2;
			///End MODIFICATION_TITLE_SHOW_DEFAULT_VALUE
			GETN_LIST(Shown, _L("Shown"), m_wp.TitleShow-1, _L("Long name|Short name|Both"))
		GETN_END_BRANCH(WindowTitle)
		
		PageSystemInfo pageInfo;
		m_wp.GetPageSystemInfo(&pageInfo);
		string strSize;
		strSize.Format("%.2fKB", pageInfo.nSize/1024.0);
				
		GETN_BEGIN_BRANCH(PageInfo, _L("Page Info")) GETN_OPTION_BRANCH(GETNBRANCH_OPEN) GETN_READ_ONLY_COLOR
			GETN_STR(Size, _L("Size"), strSize)
			//GETN_STR(Dependents, "nDependents", (string)pageInfo.nDependents) GETN_READ_ONLY
			GETN_STR(Type, _L("Type"), "Workbook")
			GETN_LIST(state, _L("stats"), m_wp.GetShow(), _L("Normal|Minimized|Maximized|Hidden"))
			GETN_STR(Created, _L("Created"), get_date_str(pageInfo.dCreated))
			GETN_STR(Modified, _L("Modified"), get_date_str(pageInfo.dModified))
			//------ Folger 11/23/07 FIX_RUNTIME_ERROR_WHEN_FAIL_TO_GET_PAGE_FOLDER
			//GETN_STR(Location, _L("Location"), m_wp.GetFolder().GetPath())
			Folder fld = m_wp.GetFolder();
			GETN_STR(Location, _L("Location"), fld.IsValid() ? m_wp.GetFolder().GetPath() : "")
			//------
		GETN_END_BRANCH(WindowTitle)
		
		return true;
	}
	bool GetSheetInfo(TreeNode &trGetN, TreeNode &trSheet)
	{
		string strSheetName;
		trSheet.GetAttribute(STR_LABEL_ATTRIB, strSheetName);
		Worksheet wks=m_wp.Layers(strSheetName);
		///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
		MatrixLayer ml=m_wp.Layers(strSheetName);
		//if(!wks)
		if (ml)
		{
			//MatrixLayer ml=m_wp.Layers(strSheetName);
			//if(!ml)
				//return false;
			getSheetView(ml, trGetN, false);
			//return true;
		}
		///End ADD_INI_BINARY_STORAGETO_MATRIX
		///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE, remove from workbook organizer
		/*
		else
			getSheetView(wks, trGetN, true);
		int nCols = wks.GetNumCols();
		int nRows = wks.GetNumRows();
		///Jasmine 10/23/06 ADD_ROW_NUM
		///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
		GETN_USE(trGetN)			
		GETN_NUM(ColNum, _L("Column Number"), nCols)	GETN_ID(BRN_WKS_COLUMNS) GETN_READ_ONLY//GETN_OLDVAL
		GETN_NUM(RowNum, _L("Row Number"), nRows)	GETN_ID(BRN_WKS_ROWS) 
		///End ADD_ROW_NUM
		*/
		///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
		///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
		OriginObject* pobj;
		if (wks)
		{
			pobj = &wks;
		}
		else
		{
			pobj = &ml;
		}
		///End ADD_INI_BINARY_STORAGETO_MATRIX
		GETN_USE(trGetN)
		///End MODIFICATION_EDIT_USER_TREE
		GETN_STR(RightClickHint, STR_RIGHT_CLICK_HINT, "")	GETN_HINT		///Jasmine 02/02/10 SHOW_RIGHT_CLICK_HINT_IN_ONE_ROW_TO_SAVE_SPACE
		GETN_BEGIN_BRANCH(LayerInfo, _L("layer.info"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			//getINIStorage(wks, GETN_CURRENT_SUBNODE);
			getINIStorage(*pobj, GETN_CURRENT_SUBNODE);
			///End ADD_INI_BINARY_STORAGETO_MATRIX
		GETN_END_BRANCH(LayerInfo)
		trGetN.LayerInfo.SetAttribute(STR_TYPE_ATTRIB, TYPE_INI_STORAGES);
		//getBinaryStorageInfo(wks ,trGetN);	///Jasmine 10/23/06 ADD_BINARY_STORAGES
		GETN_BEGIN_BRANCH(TREE, _L("User Tree"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
			//getBinaryStorageInfo(wks, GETN_CURRENT_SUBNODE);
			getBinaryStorageInfo(*pobj, GETN_CURRENT_SUBNODE);
			///End ADD_INI_BINARY_STORAGETO_MATRIX
		GETN_END_BRANCH(TREE)
		trGetN.TREE.SetAttribute(STR_TYPE_ATTRIB, TYPE_BINARY_STORAGES);
		///End EDIT_STORAGE
		/// Hong 02/03/10 QA80-15050-P2_2 WKB_ORGANIZER_SHEET_LEVEL_ADD_FILE_INFO_FOR_IMPORT
		Tree 		trFileInfo;
		if ( get_import_file_info(*pobj, trFileInfo) )
		{
			GETN_BEGIN_BRANCH(FileInfo, _L("Imported File"))	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)	GETN_READ_ONLY_COLOR
			GETN_END_BRANCH(FileInfo)
			GETN_CURRENT_SUBNODE.Replace(trFileInfo, true, true, true);
			GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TYPE_IMPORT_FILES);
		}
		/// end WKB_ORGANIZER_SHEET_LEVEL_ADD_FILE_INFO_FOR_IMPORT
		/*
		///End REMOVE_COLUMN_FROM_WBORG
		GETN_USE(trGetN)
		GETN_BEGIN_BRANCH(Text, "Text") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_BEGIN_BRANCH(Color, "Color") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_LIST(Cells, "Cells", 0, "List Color")
				GETN_LIST(Headings, "Headings", 0, "List Color")
			GETN_END_BRANCH(Color)
			GETN_BEGIN_BRANCH(Style, "Style") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
				GETN_CHECK(UseSysFonts, "Use System Fonts", 0)
				GETN_LIST(Font, "Font", 0, "List Color")
				GETN_COMBO(PtSize, "Pt Size", 0, "|14")
				GETN_CHECK(Bold, "Bold", 0)
			GETN_END_BRANCH(Style)
		GETN_END_BRANCH(Text)
		
		GETN_BEGIN_BRANCH(HeadingOptions, "Heading Options") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_CHECK(ColumnNames, "Column Names", 0)
			GETN_CHECK(MultilineName, "Multiline Name", 0)
			GETN_CHECK(ColumnLabel, "Column Label", 0)
			GETN_CHECK(Bold, "Bold", 0)
			GETN_CHECK(Row, "Row", 0)
			GETN_CHECK(Background, "Back ground", 0)
			GETN_LIST(BackgroundColor, "", 0, "List Color")
			GETN_LIST(DivideLine, "Divide Line", 0, "List Color")
		GETN_END_BRANCH(HeadingOptions)
		
		GETN_BEGIN_BRANCH(WorksheetMeasurement, "Worksheet Measurement") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_STR(ColHeadHeight, "Column Heading Height", "")
			GETN_STR(RowHeadWidth, "Row Heading Width", "")
			GETN_STR(GapFromTop, "Gap From Top", "")
		GETN_END_BRANCH(WorksheetMeasurement)
		
		GETN_BEGIN_BRANCH(Grids, "Grids") GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_CHECK(Vertical, "Vertical", 0)
			GETN_CHECK(Horizontal, "Horizontal", 0)
			GETN_LIST(HorizontalColor, "", 0, "List Color")
			GETN_COMBO(LineWidth, "Line Width", 0, "|List Width")
		GETN_END_BRANCH(Grids)
		
		GETN_CHECK(ShowDecimal, "Show 1E-5 as 0.0000 in Decimal mode", 0)
		
		GETN_BEGIN_BRANCH(PageColor, "Page Color")
			GETN_BEGIN_BRANCH(ColorControl, "Color Control")
				GETN_CHECK(NoColor, "No Color", 0)
				GETN_CHECK(BaseColorOnly, "Base Color Only", 0)
				GETN_CHECK(GradientFill, "Gradient Fill", 0)
			GETN_END_BRANCH(ColorControl)
			GETN_BEGIN_BRANCH(Colors, "Colors")
				GETN_LIST(Base, "Base", 0, "List Color")
				GETN_LIST(Gradient, "Gradient", 0, "List Color")
			GETN_END_BRANCH(Colors)
			GETN_BEGIN_BRANCH(GradientControl, "Gradient Control")
				GETN_CHECK(TopLeft, "Top Left", 0)
				GETN_CHECK(Top, "Top", 0)
				GETN_CHECK(TopRight, "Top Right", 0)
				GETN_CHECK(Left, "Left", 0)
				GETN_CHECK(Center, "Center", 0)
				GETN_CHECK(Right, "Right", 0)
				GETN_CHECK(BottomLeft, "Bottom Left", 0)
				GETN_CHECK(Bottom, "Bottom", 0)
				GETN_CHECK(BottomRight, "Bottom Right", 0)
			GETN_END_BRANCH(GradientControl)
		GETN_END_BRANCH(PageColor)
		*/
		return true;
	}
	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
	/*
	bool GetColumnInfo(Column &col, TreeNode &tr)
	{
		ColProperties colAccess(col);
		colAccess.GetTree(tr);
		return true;
	}
	*/
	//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
	//int GetWksDisplayID(Worksheet &wks)
	//{
	//	return wks.GetIndex()+SHEET_INDEX_GEGIN_ID;
	//}
	int GetWksDisplayID(Layer &ly)
	{
		ASSERT(ly); /// Hong 08/22/08 v8.0927 FIX_RUNTIME_ERROR_WHEN_DRAG_OUT_LAST_SHEET_WITH_ORGANIZER_ACTIVE
		return ly.GetIndex()+SHEET_INDEX_GEGIN_ID;
	}
	//------
	
	//-----------Folger 06/28/07 GET_TREE_ROW_NEED_FOR_SPECIFIED_NODE_TAGNAME
	int GetTreeRow(LPCSTR lpcszTagName)
	{
		TreeNode trFile = tree_get_node_by_tagname(m_wbkInfo, lpcszTagName, true);
		string strPath;
		tree_get_level(trFile, strPath);
		return octree_get_row_number(&m_wbkInfo, strPath);
	}
	//-----------Folger 06/28/07 GET_TREE_ROW_NEED_FOR_SPECIFIED_NODE_TAGNAME
	
private:
	//--- CPY 9/24/04 MULTI_SHEETS_NOT_SHOWING need to centralize logic
	// standardize how tree nodes are created
	TreeNode getMainNode(TreeNode& trParent, LPCSTR lpcszTagName, LPCSTR lpcszLabel, int nTypeID, int nID = 0)
	{
		TreeNode trN = tree_check_get_node(trParent, lpcszTagName, nID, STR_LABEL_ATTRIB, lpcszLabel);
		trN.SetAttribute(STR_TYPE_ATTRIB, nTypeID);
		return trN;
	}
	TreeNode getEnumNode(TreeNode& trParent, LPCSTR lpcszTagName, int nIndex, LPCSTR lpcszLabel, int nTypeID, int nID = 0)
	{
		TreeNode trN = check_add_enumerated_node(trParent, lpcszTagName, nIndex, nID, STR_LABEL_ATTRIB, lpcszLabel);
		trN.SetAttribute(STR_TYPE_ATTRIB, nTypeID);
		return trN;
	}
	//---
		
	void getWksDetail(Page &wp, TreeNode &tr)
	{
		/// TD 5-12-05
		if(!wp)
			return;	
		//------------
		TreeNode trPage = getMainNode(tr, "WorkBook", wp.GetName(), TYPE_WORKBOOK);
		//TreeNode trView = getMainNode(trPage, "SheetView", "Sheet View", TYPE_SHEET_VIEW);
		TreeNode trDataSheets = getMainNode(trPage, "DataSheets", _L("Data Sheets"), TYPE_DATA_SHEETS);
		TreeNode trResultSheets= getMainNode(trPage, "ResultSheets", _L("Result Sheets"), TYPE_RESULT_SHEETS);
		TreeNode trAnalysisSheets= getMainNode(trPage, "Analysis", _L("Analysis"), TYPE_ANALYSIS);
		//----- CPY 4/25/07 QA70-9362 BETTER_OP_DISPLAY_IN_WKBOOK_ORGANIZER
		//trAnalysisSheets.SetAttribute(STR_STOP_ATTRIB, 0);
		//trAnalysisSheets.SetAttribute(STR_DISPLAY_ATTRIB, IDR_RESULTS_SHEET);
		trAnalysisSheets.SetAttribute(STR_STOP_ATTRIB, 1);
		//-----
		
		//Datasheet ds;//=wp.Layers();
		//getSheetView(wks, trView);
		
		int nDataSheet = 1;
		int nResultSheet = 1;
		int nAnalysis = 1;
		foreach(Layer ly in wp.Layers)
		{
			//---- TD 8-3-06 QA70-8843 DOWNCAST_BUG
			//ds=(Datasheet)ly;
			Worksheet wks = ly;
			Datasheet ds = ly;
			//----
			if(wks.IsValid() && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY))
			{
				TreeNode trSheet = getEnumNode(trResultSheets, "Sheet", nResultSheet++, ly.GetName(), TYPE_SHEET);
				//trSheet.SetAttribute(STR_ID_ATTRIB, wks.GetIndex()+SHEET_INDEX_GEGIN_ID); //CPY, save layer id into Data for branch attribute so later can identify layer by id
				trSheet.DataID=GetWksDisplayID(ly);
				trSheet.SetAttribute(STR_DISPLAY_ATTRIB, IDR_RESULTS_SHEET);
				//getColumns(wks, trSheet);		//Danice 11/25/04 : don't show result sheet column detail
				
				string strInputSheetIDs = getOperationSource(ds, trSheet);
				trSheet.SetAttribute(STR_RELATED_ATTRIB, strInputSheetIDs);
				trSheet.SetAttribute(STR_DATA_ATTRIB, getMarkOutputColor());
			}
			else
			{
				TreeNode trSheet = getEnumNode(trDataSheets, "Sheet", nDataSheet++, ly.GetName(), TYPE_SHEET);
				trSheet.DataID=GetWksDisplayID(ly);
				///Hong 7/25/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
				//trSheet.SetAttribute(STR_DISPLAY_ATTRIB, IDR_WORKSHEETTYPE_V8);
				if(wks)
					trSheet.SetAttribute(STR_DISPLAY_ATTRIB, IDR_WORKSHEETTYPE_V8);
				else
					trSheet.SetAttribute(STR_DISPLAY_ATTRIB, IDR_MATRIXTYPE_V8);
				///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
				//getColumns(wks, trSheet);	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
				
				string strOutputSheetIDs = getAnalysisOperation(ds, trAnalysisSheets, nAnalysis);
				trSheet.SetAttribute(STR_RELATED_ATTRIB, strOutputSheetIDs);
				trSheet.SetAttribute(STR_DATA_ATTRIB, getMarkInputColor());
			}
		}
		if(1 > trDataSheets.GetNodeCount())
			trDataSheets.Remove();
		if(1 > trResultSheets.GetNodeCount())
			trResultSheets.Remove();
		//if(1 > trAnalysisSheets.GetNodeCount())		//------ Folger 11/22/07 TEMPORARY_REMOVE_ANALYSIS_NODE
			trAnalysisSheets.Remove();
		///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
		///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW
		//getImportFileInfo(wp, trPage);
		//get page.info.area
		TreeNode trPageInfo = getMainNode(trPage, "PageInfo", "page.info", TYPE_INI_STORAGES);//getPageInfo(wp, trPage);	///Jasmine 01/22/07 SHOW_PAGE_INFO_ASCII_STORAGE
		getINIStorage(wp, trPageInfo, true);
		//get import file1, file2...
		getImportFilesInfo(wp, trPage);
		//get user tree
		TreeNode trUserTree = getMainNode(trPage, "TREE", _L("User Tree"), TYPE_BINARY_STORAGES);//getBinaryStorageInfo(wp, trPage);	///Jasmine 10/23/06 ADD_BINARY_STORAGES
		getBinaryStorageInfo(wp, trUserTree, true);
		///End MAKE_A_CLEAR_TREE_VIEW
		///End EDIT_STORAGE
	}
	///Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	/*
	void getSheetView(Worksheet &wks, TreeNode &tr, bool bWks)
	{
		WksAccess wksView(wks);
		wksView.GetTree(tr);
		//tree_set_attribute_to_all_nodes(tr, STR_DATAID_ATTRIB, (string)TYPE_SHEET_VIEW_OPTIONS, true);
	}
	*/
	void getSheetView(Datasheet &wks, TreeNode &tr, bool bWks)
	{
		if(bWks)
		{
			/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
			//WksAccess wksView(wks);
			Worksheet wksheet(wks);
			WksAccess wksView(wksheet);
			/// end DOWNCAST_BUG
			wksView.GetTree(tr);
			return;
		}
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		//MatAccess matView(wks);
		MatrixLayer mtx(wks);
		MatAccess matView(mtx);
		/// end DOWNCAST_BUG
		matView.GetTree(tr);
		//-------Folger 07/20/07 FIX_BUGS_OF_MARTRIX_VIEW_MODE_IN_ORGANIZER
		//TreeNode trDataImage = tree_get_node_by_tagname(tr, "DataImage", true);
		//if (trDataImage)
			//trDataImage.nVal = mtx.MatrixObjects(0).IsImageView();
		//-------End FIX_BUGS_OF_MARTRIX_VIEW_MODE_IN_ORGANIZER
		//tree_set_attribute_to_all_nodes(tr, STR_DATAID_ATTRIB, (string)TYPE_SHEET_VIEW_OPTIONS, true);
	}
	///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	///Jasmine 07/19/06 REMOVE_COLUMN_FROM_WBORG
	/*
	void getColumns(Worksheet &wks, TreeNode &tr)
	{
		TreeNode trColumns = getMainNode(tr, "Columns", _L("Columns"), TYPE_COLUMN, TRGP_BRANCH);

		foreach(Column col in wks.Columns)
		{
			string strColName=col.GetName(), strFormatName;
			strFormatName.Format("Col(%s)", strColName);
			TreeNode trCol=tree_check_get_node(trColumns, strColName, 0, STR_LABEL_ATTRIB, strFormatName);
			GetColumnInfo(col, trCol);
		}
	}
	*/
	//return Source Sheet ID list, separate with ','
	string getOperationSource(Datasheet& wks, TreeNode &trResult)
	{
		string str;
		vector<uint> vUIDs;
		vector<string> vsSourceSheetIDs;
		if(wks.FindIncomingOperations(vUIDs))
		{
			for(int ii = 0; ii < vUIDs.GetSize(); ii++)
			{
				Operation &op = (Operation &) Project.GetOperationObject(vUIDs[ii]);
				if(op)
				{
					Worksheet wksSource=getInputSheet(op);
					if(wksSource.IsValid())
						vsSourceSheetIDs.Add(GetWksDisplayID(wksSource));
				}
			}
		}
		str.SetTokens(vsSourceSheetIDs, ',');
		return str;
	}
	//return Analysis Output sheet ID list, separate with ','
	string getAnalysisOperation(Datasheet& wks, TreeNode& tr, int& nAnalysis)
	{
		vector<string> vsAnalysisNames, vsDescriptions, vsInputNames, vsOutputNames, vsOutputSheetIDs;
		vector<uint> vnOpIDs;
		int nSize=find_analysis_operation_info(wks, vsAnalysisNames, vsDescriptions, vsInputNames, vsOutputNames, vnOpIDs, vsOutputSheetIDs);
		for(int ii=0; ii < nSize; ii++)
		{
			TreeNode trAnalysis=getEnumNode(tr, "Analysis", nAnalysis++, vsAnalysisNames[ii], TYPE_ANALYSIS);
			GETN_USE(trAnalysis)
			GETN_STR(Descriptions, _L("Descriptions"), vsDescriptions[ii]);
			GETN_STR(Input, _L("Input"), vsInputNames[ii]);
			GETN_STR(Output, _L("OutputSheet"), vsOutputNames[ii]);
			GETN_STR(UID, _L("UID"), (string)vnOpIDs[ii])
			trAnalysis.UID.Show=false;
		}
		string strList;
		strList.SetTokens(vsOutputSheetIDs, ',');
		return strList;
	}
	///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
	///Jasmine 01/22/07 SHOW_PAGE_INFO_ASCII_STORAGE
	//void getPageInfo(OriginObject &obj, TreeNode &trInfo)
	void getINIStorage(OriginObject &obj, TreeNode &trInfo, bool bSectionOnly = false)
	{
		if(!obj)
			return;
		Tree trStorage;
		if(tree_add_info(trStorage, obj, NULL, NULL, NPLOT_FOR_WKS) && !trStorage.IsEmpty() )
		{	
			//TreeNode trPageInfo = getMainNode(trInfo, "PageInfo", _L("page.info"), TYPE_INI_STORAGE);
			trInfo.Replace(trStorage, true, true, true);
			foreach(TreeNode cNode in trInfo.Children)
			{
				if(bSectionOnly)//stop at section level
					cNode.Reset(true);
				///Folger 05/28/07 ADD_INI_BINARY_STORAGETO_MATRIX
				cNode.SetAttribute(STR_ID_ATTRIB, TRGP_BRANCH);
				cNode.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
				///End ADD_INI_BINARY_STORAGETO_MATRIX
				cNode.SetAttribute(STR_TYPE_ATTRIB, TYPE_SECTION);
				string strStorage = cNode.tagName;
				strStorage = strStorage.GetToken(0, '.');
				if(cNode.Enable == 0 || cNode.Enable == 2 || !strStorage.CompareNoCase("system"))
					_make_tree_node_readonly(cNode);
			}
		}
		else
		{
			TreeNode trNoInfo = trInfo.AddTextNode(_L("No Info."), "NoInfo");
			trNoInfo.SetAttribute(STR_TYPE_ATTRIB, TYPE_SECTION);
			//------ Folger 11/17/07 LOCALIZE_WORKBOOK_ORGANIZER
			//trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
			trNoInfo.SetAttribute(STR_LABEL_ATTRIB, bSectionOnly ? _L("No Info.") : "");
			//------ End LOCALIZE_WORKBOOK_ORGANIZER
			trNoInfo.Enable = 2;
		}
		_make_tree_node_expand(trInfo);	
	}
	///End SHOW_PAGE_INFO_ASCII_STORAGE
	///End EDIT_STORAGE
	void getImportFilesInfo(Page &wp, TreeNode &tr)	///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW
	{
		//get import files
		Tree trInfo;
		if( tree_get_binary_storage(trInfo, wp, IFI_BINARY_STORAGE_NAME) )
		{
			TreeNode trImportFiles=getMainNode(tr, "ImportedFiles", _L("Imported Files"), TYPE_IMPORT_FILES);
			trImportFiles.Reset(true);
			string str;
			///Jasmine 02/14/07 DELETE_IMPORTED_FILE, use foreach to replace get node from File#, because some File# may have been deleted
			//for(int ii=1; ;ii++)
			int ii = 1;
			foreach(TreeNode trn in trInfo.Children)
			{
				//str.Format(IFI_FILE_NODE_ENUM_NAME, ii);
				//TreeNode trn = trInfo.GetNode(str);
				//if( trn )
				str = trn.tagName;
				string strTemp = str;
				strTemp.TrimLeft("File");
				if(str.Find("File") == 0 && is_numeric(strTemp))//str should be like File#
				{
					ii = atoi(strTemp);
			///End DELETE_IMPORTED_FILE
					///Jasmine 02/07/07 MAKE_A_CLEAR_TREE_VIEW, only show File level
					//trImportFiles.AddNode(trn);
					trImportFiles.AddNode(str);
					///End MAKE_A_CLEAR_TREE_VIEW
					TreeNode trFile=getEnumNode(trImportFiles, "File", ii, trn.Info.FileName.strVal, TYPE_FILE, TRGP_BRANCH);
					tree_set_attribute_to_all_nodes(trFile, STR_ID_ATTRIB, (string)TRGP_BRANCH, false, true);
					trFile.SetAttribute(STR_DISPLAY_ATTRIB, IDR_IMPORTED_FILE);
					/// Hong 10/30/06 INFO_NODE_SHOULD_NOT_EDITABLE
					/*
					foreach(TreeNode trChild in trFile.Info.Children)
					{
						trChild.Enable = ENABLE_READ_ONLY;
					}
					*/
					if(trn.Enable == 0 || trn.Enable == 2)
						_make_tree_node_readonly(trFile);
					/// end INFO_NODE_SHOULD_NOT_EDITABLE
					///Danice 11/12/04 Link to worksheet by ID
					/// Hong 12/02/06 NO_NEED_CHANGE_HERE
					/*
					/// Hong 11/13/06 MAKE_JULIAN_DATE_MORE_READABLE
					_show_julian_date_by_string_mode(trFile.Info.ImportDate);
					_show_julian_date_by_string_mode(trFile.Info.FileDate);
					/// end MAKE_JULIAN_DATE_MORE_READABLE
					*/
					/// end NO_NEED_CHANGE_HERE
					Datasheet wks;
					/// SY 12/17/2004 QA70-7258 v8.0177 IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID
					///if(findOwnerSheet(trFile.DataRange.Range, wks))
					if(findOwnerSheet(trFile.DataRange, wks))
					/// end IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID
					{
						trFile.SetAttribute(STR_RELATED_ATTRIB, GetWksDisplayID(wks));
						trFile.SetAttribute(STR_DATA_ATTRIB, getMarkInputColor());
					}
					///end
				}
				else
					break;
			}
		}	
	}
	///Jasmine 01/29/07 QA70-9287 EDIT_STORAGE
	///Jasmine 10/23/06 ADD_BINARY_STORAGES
	void getBinaryStorageInfo(OriginObject &obj, TreeNode &trInfo, bool bBranchOnly = false)  //// AW 11/06/06 MORE_ON_GET_BINARY_INFO don't use same local name
	{
		if(!obj)
			return;
		//// AW 11/06/06 MORE_ON_GET_BINARY_INFO
		/*
		TreeNode trStorage = getMainNode(tr, "BinaryStorages", _L("Binary Storages"), TYPE_BINARY_STORAGES);
		trStorage.Reset();			
		*/
		Tree trStorage;
		/// END MORE_ON_GET_BINARY_INFO
		///Jasmine 12/08/06 ONLY_SHOW_USER_INFO
		/*
		vector<string> vsNames;
		if(obj.GetStorageNames(vsNames))
		{
			int ii = vsNames.Find(IFI_BINARY_STORAGE_NAME);
			if(-1 < ii)
				vsNames.RemoveAt(ii);
		}
		for(int ii = 0; ii < vsNames.GetSize(); ii++)
		{
			Tree tr;
			if(obj.GetBinaryStorage(vsNames[ii], tr))
			{
				tr.SetAttribute(STR_LABEL_ATTRIB, vsNames[ii]);
				trStorage.AddNode(tr);
			}
		}
		*/
		//get_user_info(obj, NULL, trStorage);//get_user_info(obj, trStorage);	///Jasmine 01/08/07 MODIFICATION_GET_SET_USER_INFO
		tree_get_binary_storage(trStorage, obj, "TREE");///Jasmine 01/15/07 CHANGE_USER_INFO_TO_TREE, "user_info"->"tree"
		///End ONLY_SHOW_USER_INFO
		//// AW 11/06/06 MORE_ON_GET_BINARY_INFO
		if ( !trStorage.IsEmpty() )
		{	
			//TreeNode trBinary = getMainNode(trInfo, "UserTree", _L("User Tree"), TYPE_BINARY_STORAGES); ///Jasmine 12/08/06 ONLY_SHOW_USER_INFO
			trInfo.Replace(trStorage, true, true, true);
			foreach(TreeNode cNode in trInfo.Children)
			{
				if(bBranchOnly)
					cNode.Reset(true);
				cNode.SetAttribute(STR_TYPE_ATTRIB, TYPE_BRANCH);
				if(cNode.Enable == 0 || cNode.Enable == 2)
					_make_tree_node_readonly(cNode);	
			}
		}
		else
		{
			TreeNode trNoInfo = trInfo.AddTextNode(_L("No Info."), "NoInfo");
			trNoInfo.SetAttribute(STR_TYPE_ATTRIB, TYPE_BRANCH);
			//------ Folger 11/17/07 LOCALIZE_WORKBOOK_ORGANIZER
			//trNoInfo.SetAttribute(STR_LABEL_ATTRIB, "");
			trNoInfo.SetAttribute(STR_LABEL_ATTRIB, bBranchOnly ? _L("No Info.") : "");
			//------ End LOCALIZE_WORKBOOK_ORGANIZER
			trNoInfo.Enable = 2;			
		}
		/// END MORE_ON_GET_BINARY_INFO
	}
	///End ADD_BINARY_STORAGES
	///End EDIT_STORAGE
	///Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	//bool findOwnerSheet(TreeNode &trDataRange, Worksheet &wks)
	bool findOwnerSheet(TreeNode &trDataRange, Datasheet &ds)
	///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	{
		//--- CPY 7/11/06
		if(!trDataRange)
			return false;
		//----
		/// SY 12/17/2004 QA70-7258 v8.0177 IMPORT_INFO_RESET_AND_DATARANGE_SAVEAS_UID
		///	DataRange dr;
		///	int nAdded = dr.Add("", trDataRange.strVal);
		///	//CPY 12/14/04 Add may fail but dr test invalid cannot tell if range exist or not
		///	//currently, if a sheet is renamed, data range stored will be incorrect, we will fix this soon
		///	//but it is always better to add error checking to codes
		///	if(nAdded > 0)
		///	{
		///		int nIndex=0, r1, c1, r2, c2;
		///		if(dr)
		///			dr.GetRange(nIndex, r1, c1, r2, c2, wks);
		///	}
		/// Hong 11/3/06 FIX_DATA_RANGE_VALUE_CLEARED
		//DataRangeEx dr(trDataRange, true);
		DataRangeEx dr(trDataRange);
		/// end FIX_DATA_RANGE_VALUE_CLEARED
		if(dr.IsValid() && dr.GetNumData())//must check validity
			dr.GetRange(ds);
		return ds.IsValid();
	}
	int find_analysis_operation_info(Datasheet& wks, vector<string>& vsAnalysisNames, vector<string>& vsDescriptions, vector<string>& vsInputNames, vector<string>& vsOutputNames, vector<uint>& unOpIDs, vector<string>& vsOutputSheetIDs)
	{
		Page wp = wks.GetPage();
		if(!wp)
			return 0;
		int nSize=wks.FindOutgoingOperations(unOpIDs);
		if(nSize <= 0)
			return 0;
		vsAnalysisNames.SetSize(nSize);
		vsDescriptions.SetSize(nSize);
		vsInputNames.SetSize(nSize);
		vsOutputNames.SetSize(nSize);
		vsOutputSheetIDs.SetSize(nSize);
		//OperationBase op;
		
		int ii = 0;
		for(int iii = 0; iii < nSize; iii++)
		{
			//--- CPY 12/4/04 TD_FIXED_PROPER_DOWN_CASTING_SO_USE_OPERATION_INSTEAD_OF_OPERATION_BASE
			//op = Project.GetObject(unOpIDs[ii]);
			//Operation& op2 = (Operation&)Project.GetOperationObject(unOpIDs[iii]);
			Operation &op = (Operation &)Project.GetOperationObject(unOpIDs[iii]);
			
			//---
			if(op)
			{
				vsAnalysisNames[ii]=op.GetName();//op.GetClassName();
				//vsInputNames[ii]=op.GetInputDisplay();
				string strTemp;
				op.GetInputsInfo(strTemp, "\r\n", " "); vsInputNames[ii] = strTemp; 
				op.GetOutputsInfo(strTemp, "\r\n", " ");vsOutputNames[ii] = strTemp;
				//vsDescriptions[ii]=op.GetDescription(3);	//get all, temp
				double dTime;
				string strTime, strUserName, strCompanyName;
				DWORD dwDuration;
				op.GetExecutionInfo(dTime, strUserName, strCompanyName, dwDuration);
				strTemp.Format("Last Executed at %s by %s of %s", strTime, strUserName, strCompanyName);
				vsDescriptions[ii] = strTemp;
				Worksheet wResult = getOutputSheet(op);
				if(wResult)
				{
					vsOutputSheetIDs[ii]=(string)GetWksDisplayID(wResult);
				}
				ii++;
			}
		}
		return ii;
	}

	Worksheet &getOutputSheet(OperationBase& op)
	{
		DataRange dr;
		Worksheet wResult;
		if(op_get_output(op, dr, wResult) && (wResult.GetSystemParam(0) & WP_SHEET_HIERARCHY)) // only consider hierarical sheet
		{
			return wResult;
		}
		Worksheet wJunk;
		return wJunk;
	}
	Datasheet &getInputSheet(OperationBase& op)
	{
		DataRange dr;
		Worksheet wInput;
		if(op_get_input(op, dr, wInput, 0) && WP_SHEET_HIERARCHY!=(wInput.GetSystemParam(0) & WP_SHEET_HIERARCHY))
		{
			return wInput;
		}
		Worksheet wJunk;
		return wJunk;
	}
	int getMarkInputColor() { return COLOR_BLUE; }
	int getMarkOutputColor() { return COLOR_RED; }
private:
	///Hong 7/24/06 SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	//WorksheetPage		m_wp;
	Page				m_wp;
	///end SHARE_WKBOOK_MATBOOK_ORGANIZER_ADD_MORE
	Tree				m_wbkInfo;
};

#endif //_WKBOOK_INFO_TREE_H_
